<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Utils\BlockList\BlockListInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BlockItemType extends AbstractUiElementType
{
    private readonly BlockListInterface $blockList;

    public function __construct(BlockListInterface $blockList)
    {
        $this->blockList = $blockList;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('type', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.block_collection.type',
                'choices' => [
                    'dedi_cms.ui_element.text.info.title' => 'dedi_sylius_cms_plugin_text_block',
                    'monsieurbiz_richeditor_plugin.ui_element.monsieurbiz.quote.title' => 'monsieurbiz_quote',
                    'dedi_cms.ui_element.media.info.title' => 'dedi_sylius_cms_plugin_media_element',
                ],
                'attr' => [
                    'data-block-select' => 'style',
                ],
            ])
        ;

        foreach ($options['blocks'] as $option) {
            $builder
                ->add($option['name'], $option['type'], [
                    'label' => false,
                    'attr' => [
                        'data-block-type' => $option['name'],
                    ],
                    'required' => false,
                    'embedded' => true,
                ])
            ;
        }

        // this event listener removes unused data
        $builder->addEventListener(FormEvents::PRE_SUBMIT, function (FormEvent $event) use ($options): void {
            $data = $event->getData();
            $form = $event->getForm();

            foreach ($options['blocks'] as $option) {
                if ($option['name'] !== $data['type']) {
                    $form->remove($option['name']);
                    unset($data[$option['name']]);
                }
            }

            $event->setData($data);
        });
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        parent::configureOptions($resolver);

        $resolver->setDefault('blocks', $this->blockList->getList());
    }
}
