<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Entity;

use BitBag\SyliusCmsPlugin\Entity\BlockInterface;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\CodeAwareInterface;
use Symfony\Component\Validator\Constraints as Assert;
use UnexpectedValueException;

trait BlockAwareTrait
{
    /**
     * @ORM\OneToOne(targetEntity="BitBag\SyliusCmsPlugin\Entity\BlockInterface", cascade={"ALL"})
     *
     * @ORM\JoinColumn(nullable=true)
     *
     * @Assert\Valid
     */
    protected ?BlockInterface $block = null;

    public function getBlock(): ?BlockInterface
    {
        return $this->block;
    }

    public function setBlock(?BlockInterface $block): void
    {
        $this->block = $block;
    }

    public function generateBlockCode(): string
    {
        if (!$this instanceof BlockAwareInterface) {
            throw new UnexpectedValueException(sprintf('Expected argument of type "%s", "%s" given', CodeAwareInterface::class, static::class));
        }

        return strtoupper(sprintf('%s_%s', $this->getBlockCodePrefix(), $this->getCode()));
    }
}
