<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Utils\ProductAuto\Rules;

use Dedi\SyliusCmsPlugin\Repository\ProductRepositoryInterface;
use Dedi\SyliusCmsPlugin\Utils\ProductAuto\ProductAutoRuleInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;

class Random implements ProductAutoRuleInterface
{
    private readonly ChannelContextInterface $channelContext;

    private readonly LocaleContextInterface $localeContext;

    private readonly ProductRepositoryInterface $productRepository;

    public function __construct(
        ChannelContextInterface $channelContext,
        LocaleContextInterface $localeContext,
        ProductRepositoryInterface $productRepository,
    ) {
        $this->channelContext = $channelContext;
        $this->localeContext = $localeContext;
        $this->productRepository = $productRepository;
    }

    public function getProducts(int $numberOfProducts, array $configuration): array
    {
        /** @var ChannelInterface $channel */
        $channel = $this->channelContext->getChannel();

        return $this->productRepository->findRandomByChannel(
            $channel,
            $this->localeContext->getLocaleCode(),
            $numberOfProducts,
        );
    }

    public function getType(): string
    {
        return 'random';
    }

    public function getConfigurationFormClass(): ?string
    {
        return null;
    }
}
