<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\LinkType;
use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\TitleType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Count;

class ProductCollectionType extends AbstractUiElementType
{
    private readonly int $collectionCountMin;

    private readonly int $collectionCountMax;

    public function __construct(
        int $collectionCountMin,
        int $collectionCountMax,
    ) {
        $this->collectionCountMin = $collectionCountMin;
        $this->collectionCountMax = $collectionCountMax;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TitleType::class, [
                'label' => 'dedi_cms.ui_element.elements.title',
                'required' => false,
                'embedded' => true,
            ])
            ->add('link', LinkType::class, [
                'label' => 'dedi_cms.ui_element.elements.link',
                'required' => false,
                'embedded' => true,
            ])
            ->add('collection', CollectionType::class, [
            'entry_type' => ProductType::class,
            'entry_options' => [
                'embedded' => true,
                'label' => false,
            ],
            'button_add_label' => 'dedi_cms.ui_element.product_collection.add',
            'allow_add' => true,
            'prototype' => true,
            'allow_delete' => true,
            'by_reference' => false,
            'delete_empty' => true,
            'label' => 'dedi_cms.ui_element.product_collection.collection',
            'constraints' => [
                new Count([
                    'min' => $this->collectionCountMin,
                    'max' => $this->collectionCountMax,
                ]),
            ],
        ])
        ;

        $builder->get('title')
            ->remove('class')
            ->remove('subtitleClass')
        ;
    }
}
