<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Count;

class BlockCollectionType extends AbstractUiElementType
{
    private readonly int $collectionCountMin;

    private readonly int $collectionCountMax;

    public function __construct(
        int $collectionCountMin,
        int $collectionCountMax,
    ) {
        $this->collectionCountMin = $collectionCountMin;
        $this->collectionCountMax = $collectionCountMax;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder->add('collection', CollectionType::class, [
            'entry_type' => BlockItemType::class,
            'entry_options' => ['embedded' => true],
            'button_add_label' => 'dedi_cms.ui_element.block_collection.add',
            'allow_add' => true,
            'allow_delete' => true,
            'by_reference' => false,
            'delete_empty' => true,
            'label' => 'dedi_cms.ui_element.block_collection.collection',
            'constraints' => [
                new Count([
                    'min' => $this->collectionCountMin,
                    'max' => $this->collectionCountMax,
                ]),
            ],
        ]);

        $builder->remove('width');
    }
}
