<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

final class DediSyliusCmsExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @inheritdoc
     */
    public function load(array $config, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $config);
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));

        $loader->load('services.yaml');

        $container->setParameter('dedi_cms_ckeditor_config', $config['ckeditor_config']);

        $container->setParameter('dedi_cms_text_and_icon_collection_min', $config['dedi_cms_text_and_icon_collection_min']);
        $container->setParameter('dedi_cms_text_and_icon_collection_max', $config['dedi_cms_text_and_icon_collection_max']);

        $container->setParameter('dedi_cms_block_collection_min', $config['dedi_cms_block_collection_min']);
        $container->setParameter('dedi_cms_block_collection_max', $config['dedi_cms_block_collection_max']);

        $container->setParameter('dedi_cms_banner_collection_min', $config['dedi_cms_banner_collection_min']);
        $container->setParameter('dedi_cms_banner_collection_max', $config['dedi_cms_banner_collection_max']);

        $container->setParameter('dedi_cms_product_collection_min', $config['dedi_cms_product_collection_min']);
        $container->setParameter('dedi_cms_product_collection_max', $config['dedi_cms_product_collection_max']);
    }

    public function getAlias(): string
    {
        return 'dedi_cms_plugin';
    }

    public function prepend(ContainerBuilder $container)
    {
        $container->loadFromExtension('twig', [
            'paths' => [
                __DIR__ . '/../Resources/views/bundles/MonsieurBizSyliusRichEditorPlugin' => 'MonsieurBizSyliusRichEditorPlugin',
            ],
        ]);
    }
}
