<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\AbstractUiElementType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\AlignmentType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class TitleType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('title', TextType::class, [
                'label' => 'dedi_cms.ui_element.elements.title',
                'required' => false,
            ])
            ->add('htmlTag', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.elements.html_tag',
                'choices' => [
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6',
                    'P' => 'p',
                ],
            ])
            ->add('class', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.elements.class',
                'choices' => [
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6',
                    'P' => 'p',
                ],
            ])
            ->add('subtitle', TextType::class, [
                'label' => 'dedi_cms.ui_element.elements.sub_title',
                'required' => false,
            ])
            ->add('subtitleHtmlTag', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.elements.subtitle_html_tag',
                'choices' => [
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6',
                    'P' => 'p',
                ],
            ])
            ->add('subtitleClass', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.elements.subtitle_class',
                'choices' => [
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6',
                ],
            ])
        ;

        /** @var bool $embedded */
        $embedded = $options['embedded'];

        if (!$embedded) {
            $builder->add('align', AlignmentType::class, [
                'show_justify' => false,
            ]);
        }

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event): void {
            $data = $event->getData();
            $data['htmlTag'] = $data['htmlTag'] ?? 'h2';
            $data['class'] = $data['class'] ?? 'h2';
            $data['subtitleHtmlTag'] = $data['subtitleHtmlTag'] ?? 'h3';
            $data['subtitleClass'] = $data['subtitleClass'] ?? 'h3';
            $event->setData($data);
        })
        ;
    }
}
