<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\Extension\UiElement;

use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

abstract class AbstractUiElementTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $embedded = array_key_exists('embedded', $options) ? $options['embedded'] : false;
        if (false === $embedded) {
            $builder
                ->add('width', ChoiceType::class, [
                    'label' => 'dedi_cms.ui_element.elements.width',
                    'choices' => [
                        '100%' => 100,
                        '75%' => 75,
                        '66%' => 66,
                        '50%' => 50,
                        '33%' => 33,
                        '25%' => 25,
                    ],
                    'empty_data' => 100,
                ])
            ;
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefault('embedded', false);
    }
}
