<h1>
    CMS Plugin for Sylius by Dedi
</h1>

<p>
This plugin uses :

* BitBagCommerce/SyliusCmsPlugin : https://github.com/BitBagCommerce/SyliusCmsPlugin
* monsieurbiz/SyliusRichEditorPlugin : https://github.com/monsieurbiz/SyliusRichEditorPlugin
</p>

## Quickstart Installation

```
$ make start
$ make db-create
$ make db-update
$ make fixtures

$ make build
$ make assets
```

## Installation

### Installing the main plugin :

Run ``composer require dedi/sylius-cms-plugin``

Change your `config/bundles.php` file to add the line for the plugin : 
   
```php
   <?php
   
   return [
       //..
       Dedi\SyliusCmsPlugin\DediSyliusCmsPlugin::class => ['all' => true],
];
```

Import routing in your `config/routes.yaml` file:
```yaml
dedi_sylius_cms_plugin_shop:
    resource: "@DediSyliusCmsPlugin/Resources/config/shop_routing.yaml"
    prefix: /{_locale}
    requirements:
        _locale: ^[a-z]{2}(?:_[A-Z]{2})?$

dedi_sylius_cms_plugin_admin:
    resource: "@DediSyliusCmsPlugin/Resources/config/admin_routing.yaml"
    prefix: /admin

dedi_sylius_cms_plugin_sitemap:
    resource: "@DediSyliusCmsPlugin/Resources/config/sitemap_routing.yaml"

```

Import required config in your `config/packages/_sylius.yaml` file:

```yaml
# config/packages/_sylius.yaml

imports:
    ...

    - { resource: '@DediSyliusCmsPlugin/Resources/config/config.yaml' }
```

Edit twig config `config/packages/twig.yaml` file:

```yaml
# config/packages/twig.yaml

form_themes:
    - '@FOSCKEditor/Form/ckeditor_widget.html.twig'
```

Edit the `config/packages/doctrine.yaml` file :

```yaml
# config/packages/doctrine.yaml
imports:
    - { resource: "@DediSyliusCmsPlugin/Resources/config/doctrine.yaml" }
```

Note that this adds doctrine support for the MySQL `RAND()` function. If you use another platform, make sure you implement the `RAND()` function to that specific platform

Extend the `ProductRepository`:

```php
<?php

declare(strict_types=1);

namespace App\Repository;

use Dedi\SyliusCmsPlugin\Repository\ProductRepositoryInterface as DediSyliusCmsPluginOrderItemRepositoryInterface;
use Dedi\SyliusCmsPlugin\Repository\ProductRepositoryTrait;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\ProductRepository as BaseProductRepository;

class ProductRepository extends BaseProductRepository implements DediSyliusCmsPluginOrderItemRepositoryInterface
{
    use ProductRepositoryTrait;
}
```

Add configuration for the `ProductRepository` in  `config/packages/_sylius.yaml`:

```php
sylius_product:
    resources:
        product:
            classes:
                repository: App\Repository\ProductRepository
```

### Installing `monsieurbiz/SyliusRichEditorPlugin` :

From their documentation : https://github.com/monsieurbiz/SyliusRichEditorPlugin

Change your `config/bundles.php` file to add the line for the plugin : 
   
```php
   <?php
   
   return [
       //..
       MonsieurBiz\SyliusRichEditorPlugin\MonsieurBizSyliusRichEditorPlugin::class => ['all' => true],   
];
```

Build the assets :

```bash
$ bin/console assets:install
```

### Installing `` BitBagCommerce/SyliusCmsPlugin``
From their documentation : https://github.com/BitBagCommerce/SyliusCmsPlugin/blob/master/doc/installation.md

Add plugin dependencies to your `config/bundles.php` file:
```php
return [
    ...

    FOS\CKEditorBundle\FOSCKEditorBundle::class => ['all' => true], // WYSIWYG editor
    SitemapPlugin\SitemapPlugin::class => ['all' => true], // Sitemap support
    BitBag\SyliusCmsPlugin\BitBagSyliusCmsPlugin::class  => ['all' => true],
];
```
The first line above (FOSCKEditorBundle) might have been already added during composer require command.

Add routes.

```yaml
# config/routes/monsieurbiz_sylius_rich_editor.yaml

monsieurbiz_richeditor_admin:
  resource: "@MonsieurBizSyliusRichEditorPlugin/Resources/config/routing/admin.yaml"
  prefix: /%sylius_admin.path_name%
```

Install WYSIWYG editor ([FOS CKEditor](https://symfony.com/doc/master/bundles/FOSCKEditorBundle/usage/ckeditor.html))

```bash
$ bin/console ckeditor:install
```

Finish the installation by updating the database schema and installing assets:
```
$ bin/console doctrine:migrations:diff
$ bin/console doctrine:migrations:migrate
$ bin/console assets:install --symlink
$ bin/console sylius:theme:assets:install --symlink
```

### Configure the plugin :

```yaml
# config/packages/dedi_cms_plugin.yaml

dedi_cms_plugin:
  ckeditor_config: ~ # FOS CKEditor config to use. If none is defined, it will use the default one.
  dedi_cms_text_and_icon_collection_min: 1 # the minimum amount of items in a text & icon collection block
  dedi_cms_text_and_icon_collection_max: 5 # the maximum amount of items in a text & icon collection block
  dedi_cms_banner_collection_min: 1 # the minimum amount of items in a banner collection block
  dedi_cms_banner_collection_max: 6 # the maximum amount of items in a banner collection block
  dedi_cms_block_collection_min: 1 # the minimum amount of items in a block collection block
  dedi_cms_block_collection_max: 4 # the maximum amount of items in a block collection block
  dedi_cms_product_collection_min: 1 # the maximum amount of items in a product collection block
  dedi_cms_product_collection_max: 8 # the maximum amount of items in a product collection block
```

### Add blocks

[Add your own element](https://github.com/monsieurbiz/SyliusRichEditorPlugin#create-your-own-elements)

:warning: The FormType has to be extended `AbstractUiElementType`.

This plugin adds the following extra elements:

* Text & Image

In order to add them into your own project, you should define them in `monsieurbiz_sylius_richeditor` config.

```yaml
# config/packages/monsieurbiz_sylius_richeditor.yaml

monsieurbiz_sylius_richeditor:
  ui_elements:
    app.text_and_image:
      title: 'dedi_cms.ui_element.text_and_image.title'
      description: 'dedi_cms.ui_element.text_and_image.description'
      icon: columns
      classes:
        form: Dedi\SyliusCmsPlugin\Form\Type\UiElement\TextAndImageType
      templates:
        admin_render: '/Admin/UiElement/text_and_image.html.twig'
        front_render: '/Shop/UiElement/text_and_image.html.twig'
      tags: ['blocs', 'elements']
```

Documentation [about tags](https://github.com/monsieurbiz/SyliusRichEditorPlugin/tree/v2.0.0-RC.10#filter-the-elements).

### Add block into block collection block

To make block available into block collection block, need to add tag `embeddable` into configuration like :

And attaching tag `dedi_sylius_cms.block_item` at the service

```yaml
app.my_block:
    title: app.my_block.title
    description: app.my_block.description
    icon: dot circle outline
    classes:
        form: App\Form\Type\UiElement\MyBlockType
    templates:
        admin_render: "@App/Admin/UiElement/my_block.html.twig"
        front_render: "@App/Shop/UiElement/my_block.html.twig"
    tags: ['blocks', 'embeddable']
```

### Grid

Abstract class `AbstractUiElementType` add block width, if you want to use the grid system, you have to use `Shop/UiElement/Base/column-size.html.twig` like this :

```twig
{% set width = element.width ?? 100 %}

{% embed '@DediSyliusCmsPlugin/Shop/UiElement/Grids/column-' ~ width ~ '.html.twig' %}
    {% block content %}
        <section>
            ...
        </section>
    {% endblock %}
{% endembed %}

```

To display grid use `dedi_cms_render_field` twig function, you can pass class names for rows.

```twig
<div class="bitbag-block">
    {% if null != block.name %}
        <h2>{{ block.name }}</h2>
    {% endif %}

    {{ block.content ? block.content|dedi_cms_render_field('ui horizontal segments') : '' }}
</div>
```
