<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Twig;

use Sylius\Component\Core\Repository\ProductRepositoryInterface;
use Sylius\Component\Product\Model\ProductInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class ResolveProductBlockExtension extends AbstractExtension
{
    private readonly ProductRepositoryInterface $productRepository;

    public function __construct(ProductRepositoryInterface $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_cms_resolve_product', [$this, 'resolveProduct']),
        ];
    }

    public function resolveProduct(string $code): ?ProductInterface
    {
        /** @var ?ProductInterface $product */
        $product = $this->productRepository->findOneBy([
            'code' => $code,
        ]);

        return $product;
    }
}
