<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Repository;

use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\TaxonInterface;

interface ProductRepositoryInterface
{
    public function findBestSellerByChannel(ChannelInterface $channel, string $locale, int $count): array;

    public function findRandomByChannel(ChannelInterface $channel, string $locale, int $count): array;

    public function findLatestByTaxon(ChannelInterface $channel, TaxonInterface $taxon, string $locale, int $count, bool $includeAllDescendants = false): array;
}
