<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\MediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;

class TextAndMediaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('media', MediaType::class, [
                'label' => false,
                'embedded' => true,
            ])
            ->add('mediaBeforeText', CheckboxType::class, [
                'label' => 'dedi_cms.ui_element.text_and_media.is_media_before_text',
                'required' => false,
            ])
            ->add('text', TextType::class, [
                'label' => 'dedi_cms.ui_element.text_and_media.content',
                'required' => false,
                'embedded' => true,
            ])
        ;
    }
}
