<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

abstract class AbstractUiElementType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (false === $options['embedded']) {
            $builder
                ->add('width', ChoiceType::class, [
                    'label' => 'dedi_cms.ui_element.elements.width',
                    'choices' => [
                        '100%' => 100,
                        '75%' => 75,
                        '66%' => 66,
                        '50%' => 50,
                        '33%' => 33,
                        '25%' => 25,
                    ],
                    'empty_data' => 100,
                ])
            ;
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefault('embedded', false);
    }
}
