<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\Extension\UiElement;

use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\TextType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\WysiwygType;
use Symfony\Component\Form\FormBuilderInterface;

class TextTypeExtension extends AbstractUiElementTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->remove('content')
            ->add('content', WysiwygType::class, [
                'required' => false,
                'label' => 'monsieurbiz_richeditor_plugin.ui_element.monsieurbiz.text.field.content',
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [TextType::class];
    }
}
