<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\LinkType;
use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\TitleType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\ImageType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\TextType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;

class TextAndImageType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('image', ImageType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.image',
                'embedded' => true,
            ])
            ->add('imageBeforeText', CheckboxType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.is_image_before_text',
                'required' => false,
            ])
            ->add('title', TitleType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.title',
                'required' => false,
                'embedded' => true,
            ])
            ->add('text', TextType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.content',
                'embedded' => true,
                'required' => false,
            ])
            ->add('link', LinkType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.link',
                'required' => false,
                'embedded' => true,
            ])
        ;
    }
}
