<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\LinkType;
use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\TitleType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\ImageType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class BannerType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('image', ImageType::class, [
                'label' => 'dedi_cms.ui_element.banner.image',
                'embedded' => true,
                'required' => false,
            ])
            ->add('title', TitleType::class, [
                'label' => 'dedi_cms.ui_element.banner.title',
                'embedded' => true,
            ])
            ->add('style', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.banner.style.label',
                'choices' => [
                    'dedi_cms.ui_element.banner.style.light' => 'light',
                    'dedi_cms.ui_element.banner.style.dark' => 'dark',
                ],
            ])
            ->add('text', TextType::class, [
                'label' => 'dedi_cms.ui_element.banner.content',
                'embedded' => true,
                'required' => false,
            ])
            ->add('link', LinkType::class, [
                'label' => 'dedi_cms.ui_element.banner.link',
                'embedded' => true,
                'required' => false,
            ])
        ;
        $builder
            ->get('image')
            ->remove('title')
            ->remove('link')
        ;
        $builder
            ->get('title')
            ->remove('class')
            ->remove('subtitleClass')
        ;
    }
}
