<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\Extension;

use BitBag\SyliusCmsPlugin\Form\Type\Translation\PageTranslationType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\RichEditorType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;

class PageTranslationTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->remove('content')
            ->add('content', RichEditorType::class, [
                'required' => false,
                'label' => 'dedi_cms.ui.blocks',
                'tags' => ['elements', 'blocks'],
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [PageTranslationType::class];
    }
}
