<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Twig;

use Dedi\SyliusCmsPlugin\Utils\ProductAuto\ProductAutoRuleRegistry;
use Exception;
use LogicException;
use Psr\Log\LoggerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class ResolveProductAutoRuleExtension extends AbstractExtension
{
    private readonly LoggerInterface $logger;

    private readonly ProductAutoRuleRegistry $productAutoRuleRegistry;

    public function __construct(ProductAutoRuleRegistry $productAutoRuleRegistry, LoggerInterface $logger)
    {
        $this->productAutoRuleRegistry = $productAutoRuleRegistry;
        $this->logger = $logger;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_cms_resolve_product_auto_rule', [$this, 'resolveProductAutoRule']),
        ];
    }

    public function resolveProductAutoRule(array $elementData): array
    {
        try {
            $this->validateElementData($elementData);

            $productAutoRule = $this->productAutoRuleRegistry->getProductAutoRule($elementData['rule']);

            $configurationName = sprintf('%s_configuration', $elementData['rule']);
            $configuration = array_key_exists($configurationName, $elementData) ? $elementData[$configurationName] : [];

            return $productAutoRule->getProducts($elementData['numberOfProducts'], $configuration);
        } catch (Exception $exception) {
            $this->logger->error($exception);

            return [];
        }
    }

    private function validateElementData(array $elementData): void
    {
        if (!array_key_exists('rule', $elementData)) {
            throw new LogicException('Key rule must be defined');
        }
        if (!array_key_exists('numberOfProducts', $elementData)) {
            throw new LogicException('Key numberOfProducts must be defined');
        }
    }
}
