<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\AbstractUiElementType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextType as BaseTextType;
use Symfony\Component\Form\FormBuilderInterface;

class TextAndIconType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('icon', BaseTextType::class, [
                'label' => 'dedi_cms.ui_element.text_and_icon.icon',
            ])
            ->add('text', TextType::class, [
                'required' => false,
                'embedded' => true,
                'label' => false,
            ])
            ->add('link', LinkType::class, [
                'required' => false,
                'embedded' => true,
                'label' => false,
            ])
        ;

        $builder
            ->get('link')
            ->remove('label')
        ;
        $builder
            ->get('text')
            ->remove('align')
        ;
    }
}
