<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\AbstractUiElementType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\AlignmentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class LinkType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('label', TextType::class, [
                'label' => 'dedi_cms.ui_element.elements.link_label',
                'required' => false,
            ])
            ->add('link', TextType::class, [
                'label' => 'dedi_cms.ui_element.elements.url',
                'required' => false,
            ])
        ;

        /** @var bool $embedded */
        $embedded = $options['embedded'];

        if (!$embedded) {
            $builder
                ->add('align', AlignmentType::class, [
                    'show_justify' => false,
                ])
            ;
        }
    }
}
