<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_cms_plugin');

        if (\method_exists($treeBuilder, 'getRootNode')) {
            $rootNode = $treeBuilder->getRootNode();
        } else {
            // BC layer for symfony/config 4.1 and older
            $rootNode = $treeBuilder->root('dedi_cms_plugin');
        }

        $rootNode
            ->children()
                ->scalarNode('ckeditor_config')
                    ->defaultValue(null)
                ->end()
                ->scalarNode('dedi_cms_text_and_icon_collection_min')
                    ->defaultValue(1)
                ->end()
                ->scalarNode('dedi_cms_text_and_icon_collection_max')
                    ->defaultValue(5)
                ->end()
                ->scalarNode('dedi_cms_block_collection_min')
                    ->defaultValue(1)
                ->end()
                ->scalarNode('dedi_cms_block_collection_max')
                    ->defaultValue(4)
                ->end()
                ->scalarNode('dedi_cms_banner_collection_min')
                    ->defaultValue(1)
                ->end()
                ->scalarNode('dedi_cms_banner_collection_max')
                    ->defaultValue(6)
                ->end()
                ->scalarNode('dedi_cms_product_collection_min')
                    ->defaultValue(1)
                ->end()
                ->scalarNode('dedi_cms_product_collection_max')
                    ->defaultValue(8)
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
