<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Utils\ProductAuto;

use LogicException;

class ProductAutoRuleRegistry
{
    private array $productAutoRules = [];

    /** @param iterable|ProductAutoRuleInterface[] $productAutoRules */
    public function __construct(iterable $productAutoRules)
    {
        foreach ($productAutoRules as $productAutoRule) {
            $this->productAutoRules[$productAutoRule->getType()] = $productAutoRule;
        }
    }

    /** @return array|ProductAutoRuleInterface[] */
    public function getProductAutoRules(): array
    {
        return $this->productAutoRules;
    }

    public function getProductAutoRule(string $type): ProductAutoRuleInterface
    {
        if (!$this->hasProductAutoRule($type)) {
            throw new LogicException(sprintf('ProductAutoRule %s not registered', $type));
        }

        return $this->productAutoRules[$type];
    }

    public function hasProductAutoRule(string $type): bool
    {
        return array_key_exists($type, $this->productAutoRules);
    }
}
