<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\LinkType;
use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\TitleType;
use MonsieurBiz\SyliusRichEditorPlugin\Form\Type\UiElement\TextType as BaseTextType;
use Symfony\Component\Form\FormBuilderInterface;

class TextType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('title', TitleType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.title',
                'required' => false,
                'embedded' => true,
            ])
            ->add('text', BaseTextType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.content',
                'required' => false,
                'embedded' => true,
            ])
            ->add('link', LinkType::class, [
                'label' => 'dedi_cms.ui_element.text_and_image.link',
                'required' => false,
                'embedded' => true,
            ])
        ;
    }
}
