<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Sylius\Bundle\ProductBundle\Form\Type\ProductAutocompleteChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class ProductType extends AbstractUiElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('product', ProductAutocompleteChoiceType::class, [
                'label' => $options['label'] ?? 'dedi_cms.ui_element.product.title',
                'multiple' => false,
                'required' => true,
            ])
        ;

        $builder
            ->get('product')
            ->resetModelTransformers()
        ;
    }
}
