<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type\UiElement;

use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\LinkType;
use Dedi\SyliusCmsPlugin\Form\Type\UiElement\Base\TitleType;
use Dedi\SyliusCmsPlugin\Utils\ProductAuto\ProductAutoRuleRegistry;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class ProductAutoType extends AbstractUiElementType
{
    private readonly ProductAutoRuleRegistry $productAutoRuleRegistry;

    public function __construct(
        ProductAutoRuleRegistry $productAutoRuleRegistry,
    ) {
        $this->productAutoRuleRegistry = $productAutoRuleRegistry;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('title', TitleType::class, [
                'label' => 'dedi_cms.ui_element.elements.title',
                'required' => false,
                'embedded' => true,
            ])
            ->add('link', LinkType::class, [
                'label' => 'dedi_cms.ui_element.elements.link',
                'required' => false,
                'embedded' => true,
            ])
            ->add('numberOfProducts', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.product_auto.number_of_products.label',
                'choices' => [
                    4 => 4,
                    8 => 8,
                ],
            ])
        ;

        $builder->get('title')
            ->remove('width')
            ->remove('class')
            ->remove('subtitleClass')
        ;

        $productAutoRuleChoices = [];
        foreach ($this->productAutoRuleRegistry->getProductAutoRules() as $productAutoRule) {
            $type = $productAutoRule->getType();
            $productAutoRuleChoices[sprintf('dedi_cms.ui_element.product_auto.rule.%s', $type)] = $type;

            if (null !== $productAutoRule->getConfigurationFormClass()) {
                $builder->add(sprintf('%s_configuration', $type), $productAutoRule->getConfigurationFormClass(), [
                    'label' => false,
                    'attr' => [
                        'data-block-type' => $productAutoRule->getType(),
                    ],
                ]);
            }
        }

        $builder
            ->add('rule', ChoiceType::class, [
                'label' => 'dedi_cms.ui_element.product_auto.rule.label',
                'choices' => $productAutoRuleChoices,
                'attr' => [
                    'data-block-select-type' => 'data-block-select-type',
                ],
            ])
        ;

        $builder->remove('width');
    }
}
