<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Repository;

use DateTimeImmutable;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class AlertMessageRepository extends EntityRepository implements AlertMessageRepositoryInterface
{
    public function getAvailableAlertMessages(string $type): array
    {
        $today = new DateTimeImmutable();
        $qb = $this->createQueryBuilder('am');

        $date = $this->createQueryBuilder('d')
            ->select($qb->expr()->max('d.createdAt'))
            ->andWhere($qb->expr()->eq('d.type', ':type'))
            ->andWhere($qb->expr()->eq('d.enabled', 1))
            ->andWhere($qb->expr()->orX(
                $qb->expr()->isNull('d.startDateTime'),
                $qb->expr()->lte('d.startDateTime', ':today'),
            ))
            ->andWhere($qb->expr()->orX(
                $qb->expr()->isNull('d.endDateTime'),
                $qb->expr()->gte('d.endDateTime', ':today'),
            ))
            ->setParameter('type', $type)
            ->setParameter('today', $today)
            ->getQuery()->getResult();

        return $qb
            ->where($qb->expr()->eq('am.createdAt', ':date'))
            ->setMaxResults(1)
            ->setParameter('date', $date)
            ->getQuery()
            ->getResult()
        ;
    }
}
