<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Event\Listener;

use Knp\Menu\ItemInterface;
use LogicException;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AdminMenuListener
{
    public function addAdminMenuItem(MenuBuilderEvent $event): void
    {
        $menu = $event->getMenu();

        $configurationMenu = $menu->getChild('configuration');
        if (!($configurationMenu instanceof ItemInterface)) {
            throw new LogicException('Configuration menu should be defined.');
        }

        $configurationMenu->addChild('dedi_banner_alert_messages', ['route' => 'dedi_banner_admin_alert_message_index'])
            ->setLabel('dedi_banner.ui.alert_messages')
            ->setLabelAttribute('icon', 'bullhorn')
        ;
    }
}
