<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\DependencyInjection\Settings;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;

class SettingsProvider implements SettingsProviderInterface
{
    public function __construct(private readonly SettingsInterface $settings)
    {
    }

    public function provide(bool $default = false): SettingsInterface
    {
        return $this->settings;
    }

    public function getName(): string
    {
        return 'dedi_banner_plugin';
    }
}
