<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\DependencyInjection;

use Dedi\SyliusBannerPlugin\Entity\AlertMessage;
use Dedi\SyliusBannerPlugin\Entity\AlertMessageInterface;
use Dedi\SyliusBannerPlugin\Entity\AlertMessageTranslation;
use Dedi\SyliusBannerPlugin\Entity\AlertMessageTranslationInterface;
use Dedi\SyliusBannerPlugin\Form\Type\AlertMessageTranslationType;
use Dedi\SyliusBannerPlugin\Form\Type\AlertMessageType;
use Dedi\SyliusBannerPlugin\Repository\AlertMessageRepository;
use Sylius\Bundle\ResourceBundle\SyliusResourceBundle;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_banner');
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->addDefaultsIfNotSet()
                ->children()
                ->scalarNode('driver')->defaultValue(SyliusResourceBundle::DRIVER_DOCTRINE_ORM)->end()
                ->booleanNode('enabled')->defaultValue(false)->end()
            ->end()
        ;

        $this->addResourcesSection($rootNode);

        return $treeBuilder;
    }

    private function addResourcesSection(ArrayNodeDefinition $node): void
    {
        $node
            ->children()
                ->arrayNode('resources')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('alert_message')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(AlertMessage::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(AlertMessageInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('repository')->defaultValue(AlertMessageRepository::class)->end()
                                        ->scalarNode('form')->defaultValue(AlertMessageType::class)->end()
                                    ->end()
                                ->end()
                                ->arrayNode('translation')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->arrayNode('classes')
                                        ->addDefaultsIfNotSet()
                                        ->children()
                                            ->scalarNode('model')->defaultValue(AlertMessageTranslation::class)->cannotBeEmpty()->end()
                                        ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('alert_message_translation')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(AlertMessageTranslation::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(AlertMessageTranslationInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('form')->defaultValue(AlertMessageTranslationType::class)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }
}
