<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Entity;

use DateTimeImmutable;
use DateTimeInterface;
use Sylius\Component\Resource\Model\TimestampableTrait;
use Sylius\Component\Resource\Model\TranslatableTrait;
use Sylius\Component\Resource\Model\TranslationInterface;
use Symfony\Component\Validator\Constraints as Assert;

class AlertMessage implements AlertMessageInterface
{
    use TimestampableTrait;
    use TranslatableTrait {
        __construct as private initializeTranslationsCollection;
    }

    protected ?int $id;

    protected bool $enabled = false;

    protected ?DateTimeImmutable $startDateTime;

    /**
     * @Assert\Expression(
     *     expression="value == null || value >= this.getStartDateTime()",
     *     groups={"default", "sylius"},
     *     message="dedi_banner.alert_message.end_date_can_t_be_before_start_date"
     * )
     */
    protected ?DateTimeImmutable $endDateTime;

    protected string $type = AlertMessageEnum::TOP_BAR;

    /** @var DateTimeInterface */
    protected $createdAt;

    /** @var DateTimeInterface */
    protected $updatedAt;

    protected ?string $color = null;

    public function __construct()
    {
        $this->initializeTranslationsCollection();
    }

    protected function createTranslation(): TranslationInterface
    {
        return new AlertMessageTranslation();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function setEnabled(bool $enabled): AlertMessageInterface
    {
        $this->enabled = $enabled;

        return $this;
    }

    public function getStartDateTime(): ?DateTimeImmutable
    {
        return $this->startDateTime;
    }

    public function setStartDateTime(?DateTimeImmutable $startDateTime): AlertMessageInterface
    {
        $this->startDateTime = $startDateTime;

        return $this;
    }

    public function getEndDateTime(): ?DateTimeImmutable
    {
        return $this->endDateTime;
    }

    public function setEndDateTime(?DateTimeImmutable $endDateTime): AlertMessageInterface
    {
        $this->endDateTime = $endDateTime;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getMessage(): ?string
    {
        /** @var AlertMessageTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getMessage();
    }

    public function getLink(): ?string
    {
        /** @var AlertMessageTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getLink();
    }

    public function getLinkLabel(): ?string
    {
        /** @var AlertMessageTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getLinkLabel();
    }

    public function getTitle(): ?string
    {
        /** @var AlertMessageTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getTitle();
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function setColor(?string $color): self
    {
        $this->color = $color;

        return $this;
    }
}
