<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusBannerPlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusBannerPlugin\Entity\AlertMessageEnum;
use Dedi\SyliusBannerPlugin\Repository\AlertMessageRepositoryInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class AlertMessageRetrieverExtension extends AbstractExtension
{
    private readonly AlertMessageRepositoryInterface $alertMessageRepository;

    private readonly SettingsProviderInterface $settingsProvider;

    public function __construct(
        AlertMessageRepositoryInterface $alertMessageRepository,
        SettingsProviderInterface $settingsProvider,
    ) {
        $this->alertMessageRepository = $alertMessageRepository;
        $this->settingsProvider = $settingsProvider;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction(
                'dedi_banner_retrieve_available_alert_messages',
                [$this, 'getTopBarAlertMessages'],
            ),
            new TwigFunction(
                'dedi_banner_retrieve_available_cart_alert_messages',
                [$this, 'getCartAlertMessages'],
            ),
        ];
    }

    public function getTopBarAlertMessages(): array
    {
        /** @var SettingsInterface $settings */
        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled()) {
            return [];
        }

        return $this->alertMessageRepository->getAvailableAlertMessages(AlertMessageEnum::TOP_BAR);
    }

    public function getCartAlertMessages(): array
    {
        /** @var SettingsInterface $settings */
        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled()) {
            return [];
        }

        return $this->alertMessageRepository->getAvailableAlertMessages(AlertMessageEnum::CART);
    }
}
