<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Form\Type;

use Dedi\SyliusBannerPlugin\Entity\AlertMessageEnum;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class AlertMessageType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $data = $builder->getData();

        $builder
            ->add('enabled', CheckboxType::class, [
                'label' => 'sylius.ui.enabled',
                'required' => false,
            ])
            ->add('type', ChoiceType::class, [
                'label' => 'dedi_banner.ui.alert_type',
                'required' => true,
                'choices' => [
                    'dedi_banner.ui.top_bar_type' => AlertMessageEnum::TOP_BAR,
                    'dedi_banner.ui.cart_type' => AlertMessageEnum::CART,
                ],
            ])
            ->add('startDateTime', DateTimeType::class, [
                'label' => 'dedi_banner.ui.start_datetime',
                'required' => false,
                'input' => 'datetime_immutable',
                'widget' => 'single_text',
            ])
            ->add('endDateTime', DateTimeType::class, [
                'label' => 'dedi_banner.ui.end_datetime',
                'required' => false,
                'input' => 'datetime_immutable',
                'widget' => 'single_text',
            ])
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => AlertMessageTranslationType::class,
            ])
            ->add('color', ColorType::class, [
                'label' => 'sylius.form.channel.color',
                'required' => false,
                'data' => $data->getColor() ?? $options['color'] ?? '#f6f6f6',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'color' => null,
        ]);
    }
}
