<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Url;

final class AlertMessageTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('title', TextType::class, [
                'label' => 'sylius.ui.title',
                'required' => false,
            ])
            ->add('message', TextareaType::class, [
                'label' => 'sylius.ui.message',
                'required' => true,
                'constraints' => [
                    new NotBlank(['groups' => ['sylius']]),
                ],
            ])
            ->add('link', TextType::class, [
                'label' => 'dedi_banner.ui.link',
                'required' => false,
                'constraints' => [
                    new Url(['groups' => ['default', 'sylius']]),
                ],
            ])
            ->add('linkLabel', TextType::class, [
                'label' => 'dedi_banner.ui.link_label',
                'required' => false,
            ])
        ;
    }
}
