<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Entity;

use Sylius\Component\Resource\Model\AbstractTranslation;

class AlertMessageTranslation extends AbstractTranslation implements AlertMessageTranslationInterface
{
    protected ?int $id;

    protected ?string $title = null;

    protected ?string $message = null;

    protected ?string $link = null;

    protected ?string $linkLabel = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): self
    {
        $this->message = $message;

        return $this;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }

    public function setLink(?string $link): self
    {
        $this->link = $link;

        return $this;
    }

    public function getLinkLabel(): ?string
    {
        return $this->linkLabel;
    }

    public function setLinkLabel(?string $linkLabel): self
    {
        $this->linkLabel = $linkLabel;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): self
    {
        $this->title = $title;

        return $this;
    }
}
