<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\Entity;

use DateTimeImmutable;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TimestampableInterface;
use Sylius\Component\Resource\Model\TranslatableInterface;

interface AlertMessageInterface extends ResourceInterface, TranslatableInterface, TimestampableInterface
{
    public function isEnabled(): bool;

    public function setEnabled(bool $enabled): self;

    public function getStartDateTime(): ?DateTimeImmutable;

    public function setStartDateTime(?DateTimeImmutable $startDateTime): self;

    public function getEndDateTime(): ?DateTimeImmutable;

    public function setEndDateTime(?DateTimeImmutable $endDateTime): self;

    public function getMessage(): ?string;

    public function getLink(): ?string;

    public function getLinkLabel(): ?string;

    public function getType(): ?string;

    public function setType(string $type): self;

    public function getColor(): ?string;

    public function setColor(?string $color): self;
}
