<?php

declare(strict_types=1);

namespace Dedi\SyliusBannerPlugin\DependencyInjection;

use Exception;
use Sylius\Bundle\ResourceBundle\DependencyInjection\Extension\AbstractResourceExtension;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusBannerExtension extends AbstractResourceExtension
{
    /**
     * @psalm-suppress UnusedVariable
     *
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $configs);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $this->registerResources('dedi_banner', $config['driver'], $config['resources'], $container);
        $loader->load('services.xml');

        $settingsDefinition = $container->getDefinition('dedi_sylius_banner.settings');
        $settingsDefinition->setArgument('$enabled', $config['enabled']);
    }

    public function getConfiguration(array $config, ContainerBuilder $container): ConfigurationInterface
    {
        return new Configuration();
    }
}
