<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://www.dedi-agency.com/wp-content/uploads/2014/05/Dedi_logo_HD.png" />
    </a>
</p>

<h1 align="center">Dedi Banner Plugin</h1>

<p align="center">Translation plugin for Sylius. Based on [Lexik Translation Bundle](https://github.com/lexik/LexikTranslationBundle) </p>

### Plugin features :

This plugin adds an admin menu entry named "Alert messages" which allows you to create "banner" alerts for your sylius website.

Via a classic CRUD management, you can choose between up to 2 display locations :
- top-bar => displayed on top of the header
- cart => displayed under the "coupons" section in the cart view

You'll find a few other options available, such as start & end date for the
message to be displayed, a color picker for the background and so on...

Hope you'll enjoy this plugin and that it'll fit to your needs !

### Require the plugin with composer :

```bash
composer require dedi/sylius-banner-plugin
```

### Import configuration :
```yaml
# config/packages/dedi_sylius_banner_plugin.yaml
imports:
  - { resource: '@DediSyliusBannerPlugin/Resources/config/config.yaml' }
```

### Import routing :
```yaml
# config/admin_routing.yaml
    # ...
    dedi_banner_plugin_admin_entry:
      resource: "@DediSyliusBannerPlugin/Resources/config/routes/admin_routing.yaml"
    # ...
```

### Add plugin class to your bundles.php :
```php
<?php
$bundles = [
    Dedi\SyliusBannerPlugin\DediSyliusBannerPlugin::class => ['all' => true],
];
```

### Update your database :

```bash
$ bin/console doctrine:migrations:diff
$ bin/console doctrine:migrations:migrate
```


### Clear cache :
```bash
$ bin/console cache:clear
```

# Contribute

## Documentation

For a comprehensive guide on Sylius Plugins development please go to Sylius documentation,
there you will find the <a href="https://docs.sylius.com/en/latest/plugin-development-guide/index.html">Plugin Development Guide</a>, that is full of examples.

## Quickstart Installation

```bash
$ make start
$ make db-create
$ make db-update
$ make fixtures
$ make assets
$ make build
```

