<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\File\Factory;

use Dedi\SyliusAvisVerifiesPlugin\File\ValueObject\ImportFile;
use Symfony\Component\HttpFoundation\File\File;

class ImportFileFactory implements ImportFileFactoryInterface
{
    public function create(string $remoteFilePath, string $localFilePath): ImportFile
    {
        return new ImportFile($remoteFilePath, new File($localFilePath));
    }
}
