<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Factory;

use Sylius\Component\Review\Factory\ReviewFactoryInterface;
use Sylius\Component\Review\Model\ReviewableInterface;
use Sylius\Component\Review\Model\ReviewerInterface;
use Sylius\Component\Review\Model\ReviewInterface;

class ProductReviewFactory implements ProductReviewFactoryInterface
{
    public function __construct(
        private readonly ReviewFactoryInterface $factory,
    ) {
    }

    public function createNew(): ReviewInterface
    {
        return $this->factory->createNew();
    }

    public function createForSubject(ReviewableInterface $subject): ReviewInterface
    {
        return $this->factory->createForSubject($subject);
    }

    public function createForSubjectWithReviewer(ReviewableInterface $subject, ?ReviewerInterface $reviewer): ReviewInterface
    {
        return $this->factory->createForSubjectWithReviewer($subject, $reviewer);
    }

    public function createFromAvisVerifieFeed(
        ReviewableInterface $subject,
        ReviewerInterface $reviewer,
        \SimpleXMLElement $reviewNode,
    ): ReviewInterface {
        $review = $this->createForSubjectWithReviewer($subject, $reviewer);

        $date = new \DateTime((string) $reviewNode->review_date);
        $review->setComment((string) $reviewNode->review);
        $review->setRating((int) $reviewNode->rate);
        $review->setCreatedAt($date);
        $review->setUpdatedAt($date);

        $attributes = $reviewNode->attributes();
        $review->setStatus(\in_array((string) $attributes['action'], ['NEW', 'UPDATE'], true)
            ? ReviewInterface::STATUS_ACCEPTED
            : ReviewInterface::STATUS_REJECTED)
        ;

        return $review;
    }
}
