<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Client\Factory;

use Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject\Credentials;
use Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject\CredentialsInterface;

class CredentialsFactory implements CredentialsFactoryInterface
{
    public function __construct(
        private readonly string $clientId,
        private readonly string $secretKey,
        private readonly string $websiteId,
    ) {
    }

    public function create(): CredentialsInterface
    {
        return new Credentials($this->clientId, $this->secretKey, $this->websiteId);
    }
}
