<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_avis_verifies');
        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('api')
                    ->children()
                        ->scalarNode('client_id')->end()
                        ->scalarNode('secret_key')->end()
                        ->scalarNode('website_id')->end()
                        ->scalarNode('base_auth_url')->end()
                        ->scalarNode('base_url')->end()
                        ->integerNode('delay')->defaultValue(0)->end()
                    ->end()
                ->end()
                ->arrayNode('ftp')
                    ->children()
                        ->scalarNode('backup_directory')->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
