<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Console;

use Dedi\SyliusAvisVerifiesPlugin\File\FileImporterInterface;
use Dedi\SyliusAvisVerifiesPlugin\File\ValueObject\ImportFile;
use Dedi\SyliusAvisVerifiesPlugin\Import\ReviewFileImporterInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
    name: 'dedi-sylius-avis-verifies:import:reviews-from-file',
    description: 'Import reviews from Avis Verifies.',
)]
class ImportReviewsFromFileCommand extends Command
{
    public function __construct(
        private readonly FileImporterInterface $fileImporter,
        private readonly ReviewFileImporterInterface $reviewFileImporter,
        private readonly LoggerInterface $logger,
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);

        try {
            /** @var ImportFile[] $files */
            $files = $this->fileImporter->importAll('reviews_product_');
        } catch (\Exception $e) {
            $io->error($e->getMessage());
            $this->logger->error($e->getMessage());

            return Command::FAILURE;
        }

        foreach ($files as $file) {
            try {
                $this->reviewFileImporter->import($file);
                $this->fileImporter->archiveFile($file);
                $io->success('Imported file ' . $file->getRemoteFilePath());
            } catch (\Exception $e) {
                $io->error($e->getMessage());
                $this->logger->error($e->getMessage());
            }
        }

        return Command::SUCCESS;
    }
}
