<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\File\ValueObject;

use Symfony\Component\HttpFoundation\File\File;

class ImportFile
{
    public function __construct(
        private readonly string $remoteFilePath,
        private readonly File $localFile,
    ) {
    }

    public function getRemoteFilePath(): string
    {
        return $this->remoteFilePath;
    }

    public function getLocalFile(): File
    {
        return $this->localFile;
    }
}
