<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusAvisVerifiesExtension extends Extension
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));

        $loader->load('services.xml');

        $config = $this->processConfiguration($this->getConfiguration([], $container), $configs);

        foreach ($config['api'] as $key => $value) {
            $container->setParameter('dedi_sylius_avis_verifies.api.' . $key, $value);
        }

        foreach ($config['ftp'] as $key => $value) {
            $container->setParameter('dedi_sylius_avis_verifies.ftp.' . $key, $value);
        }
    }

    public function getConfiguration(array $config, ContainerBuilder $container): ConfigurationInterface
    {
        return new Configuration();
    }
}
