<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject;

class Credentials implements CredentialsInterface
{
    public function __construct(
        private readonly string $websiteId,
        private readonly string $secretKey,
    ) {
    }

    public function getWebsiteId(): string
    {
        return $this->websiteId;
    }

    public function getSecretKey(): string
    {
        return $this->secretKey;
    }
}
