<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Client;

use Dedi\SyliusAvisVerifiesPlugin\Exception\BadSignatureException;
use Dedi\SyliusAvisVerifiesPlugin\Exception\UnknownWebsiteIdException;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;
use Symfony\Contracts\HttpClient\HttpClientInterface as BaseHttpClientInterface;

final class HttpClient implements HttpClientInterface
{
    public function __construct(
        private readonly BaseHttpClientInterface $client,
    ) {
    }

    public function post(string $url, array $body): void
    {
        $response = $this->client->request('POST', $url, [
            'body' => $body,
        ]);

        $responseData = $response->toArray();
        switch ($responseData['return']) {
            case 1:
                return;
            case 2:
                throw new BadSignatureException(\json_encode($body, \JSON_THROW_ON_ERROR));
            case 3:
                throw new UnknownWebsiteIdException(\json_encode($body, \JSON_THROW_ON_ERROR));
            case 4:
            default:
                throw new BadRequestException(\json_encode($body, \JSON_THROW_ON_ERROR));
        }
    }
}
