<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Client\Factory;

use Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject\Credentials;
use Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject\CredentialsInterface;

class CredentialsFactory implements CredentialsFactoryInterface
{
    public function __construct(
        private readonly string $websiteId,
        private readonly string $secretKey,
    ) {
    }

    public function create(): CredentialsInterface
    {
        return new Credentials($this->websiteId, $this->secretKey);
    }
}
