<p>
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

# Installation
`composer require dedi/sylius-avis-verifies-plugin`

Change your `config/bundles.php` file to add these lines for the plugin :

```php
   <?php
   
   return [
       //..
       Dedi\SyliusAvisVerifiesPlugin\DediSyliusAvisVerifiesPlugin::class => ['all' => true],
];
```

Import configuration file : 
```yaml
# config/packages/dedi_sylius_avis_verifies_plugin.yaml

imports:
  - { resource: "@DediSyliusAvisVerifiesPlugin/Resources/config/app/config.yaml" }
```

Add `.env` vars with avis verifies credentials and file paths
```ini
AVIS_VERIFIES_WEBSITE_ID=XXXX
AVIS_VERIFIES_SECRET_KEY=XXXX
# exemple: /home/project/var/avisverifies
AVIS_VERIFIES_FILE_DIRECTORY=/path/to/avisverifies/review/files
# exemple: /backup
AVIS_VERIFIES_FILE_BACKUP_DIRECTORY=/path/to/avisverifies/treated/files/relative/to/file_directory
```

Implement `AvisVerifiesAwareInterface` on `Product` model.
This makes possible to use something different to the default products id in order export.
```php
<?php

  namespace Tests\Dedi\SyliusAvisVerifiesPlugin\Application\src\Entity;

  use Dedi\SyliusAvisVerifiesPlugin\Model\AvisVerifiesAwareInterface;
  use Sylius\Component\Core\Model\Product as BaseProduct;
  use Doctrine\ORM\Mapping as ORM;

  /**
  * @ORM\Entity
  * @ORM\Table(name="sylius_product")
  */
  class Product extends BaseProduct implements AvisVerifiesAwareInterface
  {
    public function getAvisVerifiesId(): int
      {
        return (int) $this->id;
      }
  }
```

Implement `AvisVerifiesAwareRepositoryInterface` on `ProductRepository` model.
By doing so, you can create the query to retrieve products based on where the `avisVerifiesId` is stored.

```php
<?php

namespace Tests\Dedi\SyliusAvisVerifiesPlugin\Application\src\Repository;

use Dedi\SyliusAvisVerifiesPlugin\Repository\AvisVerifiesAwareRepositoryInterface;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\ProductRepository as BaseProductRepository;
use Sylius\Component\Core\Model\ProductInterface;

class ProductRepository extends BaseProductRepository implements AvisVerifiesAwareRepositoryInterface
{
    public function findOneByAvisVerifiesId(int $avisVerifiesId): ?ProductInterface
    {
        return $this->createQueryBuilder('o')
            ->andWhere('o.code = :code')
            ->setParameter('code', $avisVerifiesId)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}

```