<?php

namespace Tests\Dedi\SyliusAvisVerifiesPlugin\Application\src\Repository;

use Dedi\SyliusAvisVerifiesPlugin\Repository\AvisVerifiesAwareRepositoryInterface;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\ProductRepository as BaseProductRepository;
use Sylius\Component\Core\Model\ProductInterface;

class ProductRepository extends BaseProductRepository implements AvisVerifiesAwareRepositoryInterface
{
    public function findOneByAvisVerifiesId(int $avisVerifiesId): ?ProductInterface
    {
        return $this->createQueryBuilder('o')
            ->andWhere('o.id = :id')
            ->setParameter('id', $avisVerifiesId)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
