<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusAvisVerifiesPlugin\Application\src\AvisVerifies;

use Dedi\SyliusAvisVerifiesPlugin\Request\SendOrderRequestInterface;
use Sylius\Component\Core\Model\OrderInterface;

final class SendFulfilledOrder implements SendFulfilledOrderInterface
{
    private readonly SendOrderRequestInterface $sendOrderRequest;

    public function __construct(SendOrderRequestInterface $sendOrderRequest)
    {
        $this->sendOrderRequest = $sendOrderRequest;
    }

    public function send(OrderInterface $order): void
    {
        $this->sendOrderRequest->send($order);
    }
}
